// routes/classRoutes.js
const express = require("express");
const router = express.Router();
const classController = require("../../controller/private/classController");

// Create a class
router.post("/create-class", classController.createClass);

// Get all classes
router.get("/classes", classController.getAllClasses);

// Create a division
router.post("/create-division", classController.createDivision);

// Get divisions by class id
router.get("/divisions/:classId", classController.getDivisions);
router.get(
  "/students/:classId/:divisionId",
  classController.getStudentsByClassAndDivision
);
router.get("/staff", classController.getSaff);

module.exports = router;
